
-- Rain parameters
kPPS = 600;               -- Number of particles generated per second
kGravity = 700 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("confetti");
  SetBlendMode(kBlendNormal, 0);
  SetTexture("streamer", true);
  SetBlendMode(kBlendLit, 1);
  SetNumParticles(35);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(500);
TestDone = NewTimeout(2500);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-10,-10,0), Vec3(10,10,0) );
   InitVelocity( "vRange", Vec3(-120,-250,0), Vec3(120, -450, 0));
   InitScale( "fRange", 0.5, 1 );
   InitAge("iRange", 0, 0);
   InitExtra1("fRange",0,1);
   InitFrame(0);
   CreateParticles(20);
   InitFrame(1);
   InitColor("cSelect",Color(0,.8,.8,1), Color(1,0,0,1), Color(1,1,0,1),    Color(0,1,.2,1) );
   CreateParticles(15);
  end

  Gravity(kGravity);

   Do("move");
   DoAge("iAge");
   DoScale("fScale",
      .5, 200, 
      1, 1500,
      .0, 1000);
   Do("expire", 2000)

   DoUp( "vRotate", -.6, .6 );

end

